﻿using AutoMapper;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{

    /// <summary>
    /// AutoMapper mapping profile for the Message entity.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="18 December 2013">Initial version.</change>
    /// </history>
    internal class MessageProfile : Profile
    {

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 December 2013">Initial version.</change>
        /// </history>
        protected override void Configure()
        {
            //Data --> ViewModel:
            Mapper.CreateMap<ResponseMessage, ViewMessage>()
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => src.Description))
                .ForMember(dest => dest.Level, opt => opt.MapFrom(src => src.Level))
                ;
        }

        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 December 2013">Initial version.</change>
        /// </history>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion

    }
}
